/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.nls;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class OraDisplayLocaleInfo {
    private static final Hashtable m_cache = new Hashtable();
    private static String M_C_LANGUAGE_RESB = "oracle.ldap.util.nls.LanguageTranslations";
    private static String M_C_TERRITORY_RESB = "oracle.ldap.util.nls.TerritoryTranslations";
    private static String M_C_LANG_TERRIT_RESB = "oracle.ldap.util.nls.LanguageTerritoryTranslations";
    private static String M_C_TIMEZONE_RESB = "oracle.ldap.util.nls.TimeZoneTranslations";
    private final ResourceBundle m_language_resb;
    private final ResourceBundle m_territory_resb;
    private final ResourceBundle m_lang_territ_resb;
    private final Locale m_locale;

    private OraDisplayLocaleInfo(Locale locale) {
        this.m_locale = locale;
        this.m_language_resb = ResourceBundle.getBundle(M_C_LANGUAGE_RESB, locale);
        this.m_territory_resb = ResourceBundle.getBundle(M_C_TERRITORY_RESB, locale);
        this.m_lang_territ_resb = ResourceBundle.getBundle(M_C_LANG_TERRIT_RESB, locale);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraDisplayLocaleInfo getInstance(Locale locale) {
        OraDisplayLocaleInfo oraDisplayLocaleInfo = null;
        Hashtable hashtable = m_cache;
        synchronized (hashtable) {
            oraDisplayLocaleInfo = (OraDisplayLocaleInfo)m_cache.get(locale);
            if (oraDisplayLocaleInfo == null) {
                oraDisplayLocaleInfo = new OraDisplayLocaleInfo(locale);
            }
            m_cache.put(locale, oraDisplayLocaleInfo);
        }
        return oraDisplayLocaleInfo;
    }

    public String getDisplayTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("TimeZone object is null");
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(M_C_TIMEZONE_RESB, this.m_locale);
        try {
            return resourceBundle.getString(timeZone.getID());
        }
        catch (MissingResourceException missingResourceException) {
            return timeZone.getDisplayName(this.m_locale);
        }
    }

    public String getDisplayLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale object is null");
        }
        return this.getDisplayLocale(locale.getLanguage(), locale.getCountry());
    }

    public String getDisplayLocale(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                String string3 = this.m_lang_territ_resb.getString(string.toLowerCase());
                String string4 = this.m_territory_resb.getString(string2.toUpperCase());
                Object[] objectArray = new Object[]{string4};
                return MessageFormat.format(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                return string + " (" + string2 + ")";
            }
        }
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }
}

